/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.base;

import filenet.vw.api.VWExposedFieldDefinition;
import filenet.vw.api.VWIndexDefinition;

public class VWConfigTableModelData {
    public static final int STATUS_NONE = 0;
    public static final int STATUS_USER = 1;
    public static final int STATUS_SYSTEM = 2;
    public static final int STATUS_MANDATORY = 4;
    public static final int STATUS_OPTIONAL = 8;
    public static final int STATUS_MODIFIED = 16;
    public static final int STATUS_NEW = 32;
    private int m_nStatus = 0;
    private Object m_itemDef = null;

    public VWConfigTableModelData(Object tableDef, int nStatus) {
        this.update(tableDef, nStatus);
    }

    public Object getDefinition() {
        return this.m_itemDef;
    }

    public int getStatus() {
        return this.m_nStatus;
    }

    public void setDirty() {
        if ((this.m_nStatus & 0x20) == 0) {
            this.m_nStatus |= 0x10;
        }
    }

    public void update(Object newFieldDef, int nStatus) {
        this.m_itemDef = newFieldDef;
        this.m_nStatus = nStatus;
        if (this.m_itemDef != null) {
            if (this.m_itemDef instanceof VWExposedFieldDefinition) {
                VWExposedFieldDefinition fieldDef = (VWExposedFieldDefinition)this.m_itemDef;
                if (fieldDef.isMandatorySystemField()) {
                    this.m_nStatus |= 6;
                } else if (fieldDef.isSystemField()) {
                    this.m_nStatus |= 2;
                }
            } else if (this.m_itemDef instanceof VWIndexDefinition) {
                VWIndexDefinition indexDef = (VWIndexDefinition)this.m_itemDef;
                if (indexDef.isMandatorySystemIndex()) {
                    this.m_nStatus |= 6;
                } else if (indexDef.isSystemIndex()) {
                    this.m_nStatus |= 2;
                }
            }
        }
    }
}

